//
//  TAWEditPasswordViewController.swift
//  TAW
//
//  Created by Andrew Steven on 14/01/2019.
//  Copyright © 2019 PixelBeard. All rights reserved.
//

import UIKit

class TAWEditPasswordViewController: PBAnimatedViewController {
    
    // MARK: - Interface outlets -

    @IBOutlet weak var backButton: UIButton!
    @IBOutlet weak var oldPasswordTextField: PBTextField!
    @IBOutlet weak var newPasswordTextField: PBTextField!
    @IBOutlet weak var confirmPasswordTextField: PBTextField!
    @IBOutlet weak var saveButton: PBButton!
    
    @IBOutlet weak var saveButtonHeight: NSLayoutConstraint!
    
    // MARK: - Life cycle -
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        oldPasswordTextField.theTextFieldLabel.text = "CURRENT PASSWORD"
        oldPasswordTextField.setType(type: .password, validation_type: .password)
        oldPasswordTextField.theTextField.addTarget(self,
                                                    action: #selector(textFieldDidChange(textField:)),
                                                    for: .editingChanged)
        
        newPasswordTextField.theTextFieldLabel.text = "NEW PASSWORD"
        newPasswordTextField.setType(type: .password, validation_type: .password)
        newPasswordTextField.theTextField.addTarget(self,
                                                    action: #selector(textFieldDidChange(textField:)),
                                                    for: .editingChanged)
        
        confirmPasswordTextField.theTextFieldLabel.text = "CONFIRM NEW PASSWORD"
        confirmPasswordTextField.setType(type: .password, validation_type: .password)
        confirmPasswordTextField.theTextField.addTarget(self,
                                                        action: #selector(textFieldDidChange(textField:)),
                                                        for: .editingChanged)
        
        let tapGesture = UITapGestureRecognizer(target: self,
                                                action: #selector(dismissKeyboard))
        tapGesture.delegate = self
        self.view.addGestureRecognizer(tapGesture)
        
        self.saveButton.buttonBackgroundColor = TAW.Colors.greyButtonColor
        self.saveButton.shaddowOppacity = 0
    }
    
    override func viewWillAppear(_ animated: Bool) {
        self.animations = [.slide(.left, .slightly), .fadeIn]
        super.viewWillAppear(animated)
    }

    override func viewDidAppear(_ animated: Bool) {
        super.viewDidAppear(animated)
        self.setupView()
    }
    
    private func setupView() {
        if UIDevice.isSmallDevice {
            self.view.layoutIfNeeded()
            self.saveButtonHeight.constant = 45
            self.view.layoutIfNeeded()
        }

        if Connectivity.isConnectedToInternet {
            oldPasswordTextField.theTextField.isEnabled = true
            newPasswordTextField.theTextField.isEnabled = true
            confirmPasswordTextField.theTextField.isEnabled = true
            saveButton.isEnabled = true
        } else {
            oldPasswordTextField.theTextField.isEnabled = false
            newPasswordTextField.theTextField.isEnabled = false
            confirmPasswordTextField.theTextField.isEnabled = false
            oldPasswordTextField.alpha = 0.3
            newPasswordTextField.alpha = 0.3
            confirmPasswordTextField.alpha = 0.3
            saveButton.isEnabled = false
            PBBannerView.shared.showBanner(inView: self.navigationController!.view, withTitle: "No internet connection", style: .noInternet)
        }
    }
    
    // MARK: - UITextField -
    
    @objc func textFieldDidChange(textField: UITextField){
        self.invisibleCheck()
    }
    
    @objc func dismissKeyboard() {
        self.view.endEditing(true)
    }
    
    // MARK: - Button actions -
    
    @IBAction func goBack(_ sender: Any) {
        self.navigationController?.popViewController(animated: true)
    }
    
    @IBAction func save(_ sender: Any) {
        if valid() {
            self.updatePassword()
        }
    }
    
    // MARK: - Validation functions -
    
    private func invisibleCheck() {
        
        var isEnabled = false
        let validP1 = self.oldPasswordTextField.invisibleCheckValidation(type: .password)
        let validP2 = self.newPasswordTextField.invisibleCheckValidation(type: .password)
        let validP3 = self.confirmPasswordTextField.invisibleCheckValidation(type: .password)
        
        if validP1 && validP2 && validP3 &&
            self.newPasswordTextField.theTextField.text == self.confirmPasswordTextField.theTextField.text {
            isEnabled = true
        }
        
        if isEnabled {
            self.saveButton.buttonBackgroundColor = TAW.Colors.redButtonColor
            self.saveButton.shaddowOppacity = 1
        } else {
            self.saveButton.buttonBackgroundColor = TAW.Colors.greyButtonColor
            self.saveButton.shaddowOppacity = 0
        }
    }
    
    private func valid() -> Bool {
        
        let validP1 = self.oldPasswordTextField.checkValidation(required: true, type: .password)
        if !validP1 { return false }
        
        let validP2 = self.newPasswordTextField.checkValidation(required: true, type: .password)
        if !validP2 { return false }
        
        let validP3 = self.confirmPasswordTextField.checkValidation(required: true, type: .password)
        if !validP3 { return false }
        
        if self.newPasswordTextField.theTextField.text != self.confirmPasswordTextField.theTextField.text {
            self.confirmPasswordTextField.overrideFailValidation(message: "Passwords do not match")
            return false
        }
        
        return true
    }
    
    // MARK: - API functions -
    
    private func updatePassword() {
        
        PBLoadingOverlay.shared.showOverlay(view: (self.navigationController?.view)!,
                                            withTitle: "Updating password")
        
        let params = [
            "old_password": self.oldPasswordTextField.theTextField.text!,
            "new_password": self.newPasswordTextField.theTextField.text!
        ]
        
        APIClient.changePassword(parameters: params) { (jsonResponse, error) in
            if jsonResponse["success"] as? Bool == true {
                PBLoadingOverlay.shared.hideOverlay {
                    self.navigationController?.popViewController(animated: true)
                }
            } else {
                PBLoadingOverlay.shared.hideOverlay {
                    let message = jsonResponse["message"] as! String
                    if message == "Invalid Token" {
                        self.invalidateSession()
                    } else {
                        self.showAlertForAPIError(jsonResponse["message"] as! String)
                    }
                }
            }
        }
    }
}
